class SubmitHybridizations < ActiveRecord::Base
  def self.columns() @columns ||= []; end
  def self.column(name, sql_type = nil, default = nil, null = true)
    columns << ActiveRecord::ConnectionAdapters::Column.new(name.to_s, default, sql_type.to_s, null)
  end

  column :hybridization_date, :date
  column :charge_set_id, :integer
  column :charge_template_id, :integer

  validates_presence_of :charge_template_id
end
